//
//  Displaying_Custom_Pins_on_a_Map_ViewViewController.m
//  Displaying Custom Pins on a Map View
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Displaying_Custom_Pins_on_a_Map_ViewViewController.h"
#import "MyAnnotation.h"

@implementation Displaying_Custom_Pins_on_a_Map_ViewViewController

@synthesize myMapView;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (MKAnnotationView *)mapView:(MKMapView *)mapView 
            viewForAnnotation:(id <MKAnnotation>)annotation{
  
  MKAnnotationView *result = nil;
  
  if ([annotation isKindOfClass:[MyAnnotation class]] == NO){
    return result;
  }
  
  if ([mapView isEqual:self.myMapView] == NO){
    /* Zdarzenie ma być przetworzone tylko dla utworzonego wcześniej widoku mapy. */
    return result;
  }
  
  /* Najpierw rzutujemy opis, dla którego widok mapy wygenerował daną wiadomość delegata. */
  MyAnnotation *senderAnnotation = (MyAnnotation *)annotation;
  
  /* Używając metody klasy zdefiniowanej w klasie opisu, próbujemy otrzymać możliwy do ponownego użycia identyfikator pinezki, która zostanie utworzona. */
  NSString *pinReusableIdentifier = 
  [MyAnnotation 
   reusableIdentifierforPinColor:senderAnnotation.pinColor];
  
  /* Używając pobranego wcześniej identyfikatora, próbujemy ponownie wykorzystać pinezkę w widoku mapy. */
  MKPinAnnotationView *annotationView = (MKPinAnnotationView *)
  [mapView 
   dequeueReusableAnnotationViewWithIdentifier:
   pinReusableIdentifier];
  
  if (annotationView == nil){
    /* Jeżeli nie uda się wykorzystać istniejącej pinezki, trzeba utworzyć nową. */
    annotationView = 
    [[MKPinAnnotationView alloc]  initWithAnnotation:senderAnnotation
                                     reuseIdentifier:pinReusableIdentifier];
    
    /* Upewniamy się o możliwości wyświetlenia tytułu i (lub) podtytułu, o ile zostały zdefiniowane dla pinezki. */
    annotationView.canShowCallout = YES;
    
  }
    
  UIImage *pinImage = [UIImage imageNamed:@"BluePin.png"];
  if (pinImage != nil){
    annotationView.image = pinImage;
  }
  
  result = annotationView;
  
  return result;
}

- (void)viewDidLoad {
  [super viewDidLoad];
    
  /* Utworzenie mapy wypełniającej cały ekran. */
  self.myMapView = [[MKMapView alloc] 
                    initWithFrame:self.view.bounds];
  
  self.myMapView.delegate = self;
  
  /* Tworzona mapa ma być standardowa. */
  self.myMapView.mapType = MKMapTypeStandard;
  
  self.myMapView.autoresizingMask = 
  UIViewAutoresizingFlexibleWidth |
  UIViewAutoresizingFlexibleHeight;
  
  /* Dodanie mapy do widoku. */
  [self.view addSubview:self.myMapView];
  
  CLLocationCoordinate2D location;
  location.latitude = 50.288865;
  location.longitude = 18.662042;
  
  MyAnnotation *annotation =  [[MyAnnotation alloc] 
                               initWithCoordinates:location
                               title:@"Gliwice"
                               subTitle:@"Wydawnictwo Helion"];
  
  [self.myMapView addAnnotation:annotation];

  MKCoordinateRegion region;
  region.center = location;
  region.span.latitudeDelta = 0.01f;
  region.span.longitudeDelta = 0.01;
  
  [self.myMapView setRegion:region
                   animated:YES];
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.myMapView = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
